/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.ui.BasicComp;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ButtonComp
extends BasicComp
implements MouseListener {
    Image[] imageNormal = new Image[2];
    Image[] imageActive = new Image[2];
    Image[] imageDown = new Image[2];
    Image[] imageDisabled = new Image[2];
    static final int NORMAL = 1;
    static final int ACTIVE = 2;
    static final int DOWN = 4;
    static final int DISABLED = 8;
    int width;
    int height;
    boolean state = false;
    boolean mouseIn = false;
    boolean mouseDown = false;
    boolean mouseUp = false;
    boolean mouseClick = false;
    int visualState = 1;
    private PopupMenu menuPopup = null;
    private ContPressThread threadContPress = null;
    private boolean boolContPress = false;
    private boolean boolPopup = false;
    private boolean boolDoAction = false;
    private static final int POPUP_DELAY = 1000;

    public ButtonComp(String label, String imgNormal0, String imgActive0, String imgDown0, String imgDisabled0, String imgNormal1, String imgActive1, String imgDown1, String imgDisabled1) {
        super(label);
        this.imageNormal[0] = ButtonComp.fetchImage(imgNormal0);
        this.imageNormal[1] = ButtonComp.fetchImage(imgNormal1);
        this.imageActive[0] = ButtonComp.fetchImage(imgActive0);
        this.imageActive[1] = ButtonComp.fetchImage(imgActive1);
        this.imageDown[0] = ButtonComp.fetchImage(imgDown0);
        this.imageDown[1] = ButtonComp.fetchImage(imgDown1);
        this.imageDisabled[0] = ButtonComp.fetchImage(imgDisabled0);
        this.imageDisabled[1] = ButtonComp.fetchImage(imgDisabled1);
        this.width = this.imageNormal[0].getWidth(this);
        this.height = this.imageNormal[0].getHeight(this);
        this.visualState = 1;
        this.setSize(this.width, this.height);
        this.setVisible(true);
        this.addMouseListener(this);
    }

    public void mouseActivity() {
        if (this.isEnabled()) {
            if (this.mouseIn) {
                if (this.mouseDown) {
                    this.visualState = 4;
                    if (this.mouseUp) {
                        this.action();
                        this.visualState = 2;
                    }
                } else {
                    this.visualState = 2;
                }
            } else {
                this.visualState = 1;
            }
        } else {
            this.visualState = 8;
        }
        this.repaint();
    }

    public void action() {
        if (!this.boolDoAction) {
            return;
        }
        this.state = !this.state;
        this.informListener();
    }

    public void paint(Graphics g2) {
        int index = this.state ? 1 : 0;
        Image image = null;
        switch (this.visualState) {
            case 1: {
                image = this.imageNormal[index];
                break;
            }
            case 2: {
                image = this.imageActive[index];
                break;
            }
            case 4: {
                image = this.imageDown[index];
                break;
            }
            case 8: {
                image = this.imageDisabled[index];
            }
        }
        if (image != null) {
            g2.drawImage(image, 0, 0, this);
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.visualState = !value ? 8 : (this.mouseIn ? (this.mouseDown ? 4 : 2) : 1);
        this.repaint();
    }

    public boolean getValue() {
        return this.state;
    }

    public void setValue(boolean newState) {
        if (this.state != newState) {
            this.state = newState;
            this.repaint();
        }
    }

    public void setPopupMenu(PopupMenu menuPopup) {
        if (menuPopup != null) {
            this.setMousePopup(true);
            this.menuPopup = menuPopup;
            this.add(menuPopup);
        } else if (this.menuPopup != null) {
            this.setMousePopup(false);
            this.remove(this.menuPopup);
            this.menuPopup = null;
        }
    }

    public void setMousePopup(boolean boolPopup) {
        this.boolPopup = boolPopup;
    }

    public void setContMousePress(boolean boolSet) {
        this.boolContPress = boolSet;
    }

    public void mouseEntered(MouseEvent e2) {
        this.mouseIn = true;
        this.mouseActivity();
    }

    public void mouseExited(MouseEvent e2) {
        this.mouseIn = false;
        this.mouseActivity();
        if (this.threadContPress != null) {
            this.threadContPress.stopNormaly();
            this.threadContPress = null;
        }
    }

    public void mousePressed(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseDown = true;
            this.mouseUp = false;
            this.mouseActivity();
            if (this.boolContPress || this.boolPopup) {
                if (this.threadContPress != null) {
                    this.threadContPress.stopNormaly();
                }
                this.threadContPress = new ContPressThread(this);
                if (this.boolPopup) {
                    this.threadContPress.setDelayedPress(1000L);
                }
                this.threadContPress.start();
            }
            this.boolDoAction = true;
        }
    }

    public void mouseReleased(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseUp = true;
            this.mouseActivity();
            this.mouseUp = false;
            this.mouseDown = false;
            if (this.threadContPress != null) {
                this.threadContPress.stopNormaly();
                this.threadContPress = null;
            }
        }
    }

    public void mouseClicked(MouseEvent e2) {
        int modifier = e2.getModifiers();
        if ((modifier & 8) == 0 && (modifier & 4) == 0) {
            this.mouseClick = true;
            this.mouseActivity();
            this.mouseClick = false;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    protected void processMouseEvent(MouseEvent event) {
        super.processMouseEvent(event);
        if (event.isPopupTrigger()) {
            this.processMousePopup();
        }
    }

    protected void processMousePopup() {
        if (this.menuPopup != null) {
            this.menuPopup.show(this, 0, this.height);
        }
    }

    protected void processContPress() {
        if (this.boolContPress) {
            this.informListener();
        } else if (this.boolPopup && this.mouseIn && this.mouseDown) {
            this.boolDoAction = false;
            this.processMousePopup();
        }
    }

    class ContPressThread
    extends Thread {
        protected ButtonComp button = null;
        protected boolean boolContinueRun = true;
        protected boolean boolIgnoreFirst = true;
        protected boolean boolDelayedPress = false;
        protected long lMills = 500L;

        public ContPressThread(ButtonComp button) {
            this.button = button;
        }

        public void setDelayedPress(long lMills) {
            this.boolDelayedPress = true;
            this.lMills = lMills;
        }

        public void stopNormaly() {
            this.boolContinueRun = false;
        }

        public void run() {
            this.boolIgnoreFirst = !this.boolDelayedPress;
            while (this.boolContinueRun) {
                try {
                    ContPressThread.sleep(this.lMills);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.button != null && !this.boolIgnoreFirst) {
                    this.button.processContPress();
                }
                this.boolIgnoreFirst = false;
                if (!this.boolDelayedPress) continue;
                this.boolContinueRun = false;
            }
            this.boolDelayedPress = false;
            this.lMills = 250L;
        }
    }
}

