/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;
import javax.media.control.MonitorControl;
import javax.media.format.FormatChangeEvent;

public class PlayerWindow
extends Frame
implements ControllerListener {
    private static final String MENU_ZOOM_1_2 = JMFI18N.getResource("mediaplayer.zoom.1:2");
    private static final String MENU_ZOOM_1_1 = JMFI18N.getResource("mediaplayer.zoom.1:1");
    private static final String MENU_ZOOM_2_1 = JMFI18N.getResource("mediaplayer.zoom.2:1");
    private static final String MENU_ZOOM_4_1 = JMFI18N.getResource("mediaplayer.zoom.4:1");
    private static final String MENU_ZOOM = JMFI18N.getResource("mediaplayer.menu.zoom");
    Player player;
    Panel framePanel;
    ComponentListener cl;
    ComponentListener fcl;
    WindowListener wl;
    MouseListener ml;
    Component controlComp = null;
    Component visualComp = null;
    Insets insets;
    PopupMenu zoomMenu = null;
    boolean windowCreated = false;
    boolean newVideo = true;
    boolean panelResized = false;
    boolean autoStart = true;
    boolean autoLoop = true;
    Component progressBar = null;
    private Integer playerLock = new Integer(1);

    public PlayerWindow(Player player) {
        this(player, JMFI18N.getResource("mediaplayer.windowtitle"), true, true);
    }

    public PlayerWindow(Player player, String title) {
        this(player, title, true, true);
    }

    public PlayerWindow(Player player, String title, boolean autoStart) {
        this(player, title, autoStart, true);
    }

    public PlayerWindow(Player player, String title, boolean autoStart, boolean autoLoop) {
        super(title);
        this.autoStart = autoStart;
        this.autoLoop = autoLoop;
        this.player = player;
        this.setLayout(new BorderLayout());
        this.framePanel = new Panel();
        this.framePanel.setLayout(null);
        this.add((Component)this.framePanel, "Center");
        this.insets = this.getInsets();
        this.setSize(this.insets.left + this.insets.right + 320, this.insets.top + this.insets.bottom + 30);
        this.setVisible(true);
        this.wl = new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                PlayerWindow.this.killThePlayer();
            }
        };
        this.addWindowListener(this.wl);
        this.fcl = new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                PlayerWindow.this.panelResized = true;
                PlayerWindow.this.doResize();
            }
        };
        this.framePanel.addComponentListener(this.fcl);
        this.fcl = new ComponentAdapter(){

            public void componentResized(ComponentEvent ce) {
                PlayerWindow.this.insets = PlayerWindow.this.getInsets();
                Dimension dim = PlayerWindow.this.getSize();
                PlayerWindow.this.framePanel.setSize(dim.width - PlayerWindow.this.insets.left - PlayerWindow.this.insets.right, dim.height - PlayerWindow.this.insets.top - PlayerWindow.this.insets.bottom);
            }
        };
        this.addComponentListener(this.fcl);
        player.addControllerListener(this);
        player.realize();
    }

    void sleep(long time) {
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNotify() {
        super.addNotify();
        this.windowCreated = true;
        this.invalidate();
    }

    public void doResize() {
        Dimension d2 = this.framePanel.getSize();
        int videoHeight = d2.height;
        if (this.controlComp != null) {
            if ((videoHeight -= this.controlComp.getPreferredSize().height) < 2) {
                videoHeight = 2;
            }
            if (d2.width < 80) {
                d2.width = 80;
            }
            this.controlComp.setBounds(0, videoHeight, d2.width, this.controlComp.getPreferredSize().height);
            this.controlComp.invalidate();
        }
        if (this.visualComp != null) {
            this.visualComp.setBounds(0, 0, d2.width, videoHeight);
        }
        this.framePanel.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killThePlayer() {
        Integer n2 = this.playerLock;
        synchronized (n2) {
            if (this.visualComp != null) {
                this.framePanel.remove(this.visualComp);
                this.visualComp = null;
            }
            if (this.controlComp != null) {
                this.framePanel.remove(this.controlComp);
                this.controlComp = null;
            }
            if (this.player != null) {
                this.player.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent ce) {
        Integer n2 = this.playerLock;
        synchronized (n2) {
            CachingControl cc;
            if (ce instanceof RealizeCompleteEvent) {
                int width = 320;
                int height = 0;
                this.insets = this.getInsets();
                if (this.progressBar != null) {
                    this.framePanel.remove(this.progressBar);
                }
                if ((this.visualComp = this.player.getVisualComponent()) != null) {
                    width = this.visualComp.getPreferredSize().width;
                    height = this.visualComp.getPreferredSize().height;
                    this.framePanel.add(this.visualComp);
                    this.visualComp.setBounds(0, 0, width, height);
                    this.addPopupMenu(this.visualComp);
                } else {
                    MonitorControl mc = (MonitorControl)this.player.getControl("javax.media.control.MonitorControl");
                    if (mc != null) {
                        Panel mainPanel;
                        Control[] controls = this.player.getControls();
                        Panel currentPanel = mainPanel = new Panel(new BorderLayout());
                        for (int i2 = 0; i2 < controls.length; ++i2) {
                            if (!(controls[i2] instanceof MonitorControl)) continue;
                            mc = (MonitorControl)controls[i2];
                            mc.setEnabled(true);
                            if (mc.getControlComponent() == null) continue;
                            currentPanel.add("North", mc.getControlComponent());
                            Panel newPanel = new Panel(new BorderLayout());
                            currentPanel.add("South", newPanel);
                            currentPanel = newPanel;
                        }
                        this.visualComp = mainPanel;
                        width = this.visualComp.getPreferredSize().width;
                        height = this.visualComp.getPreferredSize().height;
                        this.framePanel.add(this.visualComp);
                        this.visualComp.setBounds(0, 0, width, height);
                    }
                }
                this.controlComp = this.player.getControlPanelComponent();
                if (this.controlComp != null) {
                    int prefHeight = this.controlComp.getPreferredSize().height;
                    this.framePanel.add(this.controlComp);
                    this.controlComp.setBounds(0, height, width, prefHeight);
                    height += prefHeight;
                }
                this.setSize(width + this.insets.left + this.insets.right, height + this.insets.top + this.insets.bottom);
                if (this.autoStart) {
                    this.player.prefetch();
                }
            } else if (ce instanceof PrefetchCompleteEvent) {
                if (this.visualComp != null) {
                    Dimension vSize = this.visualComp.getPreferredSize();
                    if (this.controlComp != null) {
                        vSize.height += this.controlComp.getPreferredSize().height;
                    }
                    this.panelResized = false;
                    this.setSize(vSize.width + this.insets.left + this.insets.right, vSize.height + this.insets.top + this.insets.bottom);
                    int waited = 0;
                    while (!this.panelResized && waited < 2000) {
                        try {
                            waited += 50;
                            Thread.currentThread();
                            Thread.sleep(50L);
                            Thread.currentThread();
                            Thread.yield();
                        }
                        catch (Exception e2) {}
                    }
                } else {
                    int height = 1;
                    if (this.controlComp != null) {
                        height = this.controlComp.getPreferredSize().height;
                    }
                    this.setSize(320 + this.insets.left + this.insets.right, height + this.insets.top + this.insets.bottom);
                }
                if (this.autoStart && this.player != null && this.player.getTargetState() != 600) {
                    this.player.start();
                }
            } else if (ce instanceof EndOfMediaEvent) {
                if (this.autoLoop) {
                    this.player.setMediaTime(new Time(0L));
                    this.player.start();
                }
            } else if (ce instanceof ControllerErrorEvent) {
                System.err.println("Received controller error");
                this.killThePlayer();
                this.dispose();
            } else if (ce instanceof SizeChangeEvent) {
                if (this.framePanel != null) {
                    SizeChangeEvent sce = (SizeChangeEvent)ce;
                    int nooWidth = sce.getWidth();
                    int nooHeight = sce.getHeight();
                    if (this.controlComp != null) {
                        nooHeight += this.controlComp.getPreferredSize().height;
                    }
                    if (this.framePanel.getSize().width != nooWidth || this.framePanel.getSize().height != nooHeight) {
                        this.setSize(nooWidth + this.insets.left + this.insets.right, nooHeight + this.insets.top + this.insets.bottom);
                    } else {
                        this.doResize();
                    }
                    if (this.controlComp != null) {
                        this.controlComp.invalidate();
                    }
                }
            } else if (ce instanceof FormatChangeEvent) {
                Dimension vSize = new Dimension(320, 0);
                Component oldVisualComp = this.visualComp;
                this.visualComp = this.player.getVisualComponent();
                if (this.visualComp != null && oldVisualComp != this.visualComp) {
                    if (oldVisualComp != null && this.zoomMenu != null) {
                        oldVisualComp.remove(this.zoomMenu);
                    }
                    this.framePanel.remove(oldVisualComp);
                    vSize = this.visualComp.getPreferredSize();
                    this.framePanel.add(this.visualComp);
                    this.visualComp.setBounds(0, 0, vSize.width, vSize.height);
                    this.addPopupMenu(this.visualComp);
                }
                Component oldComp = this.controlComp;
                this.controlComp = this.player.getControlPanelComponent();
                if (this.controlComp != null && oldComp != this.controlComp) {
                    this.framePanel.remove(oldComp);
                    this.framePanel.add(this.controlComp);
                    if (this.controlComp != null) {
                        int prefHeight = this.controlComp.getPreferredSize().height;
                        this.controlComp.setBounds(0, vSize.height, vSize.width, prefHeight);
                    }
                }
            } else if (ce instanceof ControllerClosedEvent) {
                if (this.visualComp != null) {
                    if (this.zoomMenu != null) {
                        this.visualComp.remove(this.zoomMenu);
                    }
                    this.visualComp.removeMouseListener(this.ml);
                }
                this.removeWindowListener(this.wl);
                this.removeComponentListener(this.cl);
                if (this.framePanel != null) {
                    this.framePanel.removeAll();
                }
                this.player = null;
                this.visualComp = null;
                this.controlComp = null;
                this.sleep(200L);
                this.dispose();
            } else if (ce instanceof CachingControlEvent && (cc = ((CachingControlEvent)ce).getCachingControl()) != null && this.progressBar == null) {
                this.progressBar = cc.getControlComponent();
                if (this.progressBar == null) {
                    this.progressBar = cc.getProgressBarComponent();
                }
                if (this.progressBar != null) {
                    this.framePanel.add(this.progressBar);
                    Dimension prefSize = this.progressBar.getPreferredSize();
                    this.progressBar.setBounds(0, 0, prefSize.width, prefSize.height);
                    this.insets = this.getInsets();
                    this.framePanel.setSize(prefSize.width, prefSize.height);
                    this.setSize(this.insets.left + this.insets.right + prefSize.width, this.insets.top + this.insets.bottom + prefSize.height);
                }
            }
        }
    }

    public void zoomTo(float z) {
        if (this.visualComp != null) {
            this.insets = this.getInsets();
            Dimension d2 = this.visualComp.getPreferredSize();
            d2.width = (int)((float)d2.width * z);
            d2.height = (int)((float)d2.height * z);
            if (this.controlComp != null) {
                d2.height += this.controlComp.getPreferredSize().height;
            }
            this.setSize(d2.width + this.insets.left + this.insets.right, d2.height + this.insets.top + this.insets.bottom);
        }
    }

    private void addPopupMenu(Component visual) {
        this.zoomMenu = new PopupMenu(MENU_ZOOM);
        ActionListener zoomSelect = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String action = ae.getActionCommand();
                if (action.equals(MENU_ZOOM_1_2)) {
                    PlayerWindow.this.zoomTo(0.5f);
                } else if (action.equals(MENU_ZOOM_1_1)) {
                    PlayerWindow.this.zoomTo(1.0f);
                } else if (action.equals(MENU_ZOOM_2_1)) {
                    PlayerWindow.this.zoomTo(2.0f);
                } else if (action.equals(MENU_ZOOM_4_1)) {
                    PlayerWindow.this.zoomTo(4.0f);
                }
            }
        };
        visual.add(this.zoomMenu);
        MenuItem mi = new MenuItem(MENU_ZOOM_1_2);
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem(MENU_ZOOM_1_1);
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem(MENU_ZOOM_2_1);
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem(MENU_ZOOM_4_1);
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        this.ml = new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, me.getX(), me.getY());
                }
            }

            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, me.getX(), me.getY());
                }
            }

            public void mouseClicked(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, me.getX(), me.getY());
                }
            }
        };
        visual.addMouseListener(this.ml);
    }
}

