/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JDK12Security;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12Action;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class MediaThread
extends Thread {
    private static ThreadGroup threadGroup;
    static boolean securityPrivilege;
    private static final boolean debug = false;
    private static int controlPriority;
    private static int audioPriority;
    private static int videoPriority;
    private static int networkPriority;
    private static int videoNetworkPriority;
    private static int defaultMaxPriority;

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup current = null;
        try {
            ThreadGroup g2 = current = Thread.currentThread().getThreadGroup();
            while (g2.getParent() != null) {
                g2 = g2.getParent();
            }
            return g2;
        }
        catch (Exception e2) {
            return null;
        }
        catch (Error e3) {
            return null;
        }
    }

    public MediaThread() {
        this("JMF thread");
    }

    public MediaThread(String name) {
        super(threadGroup, name);
    }

    public MediaThread(Runnable r) {
        this(r, "JMF thread");
    }

    public MediaThread(Runnable r, String name) {
        super(threadGroup, r, name);
    }

    public void useControlPriority() {
        this.usePriority(controlPriority);
    }

    public void useAudioPriority() {
        this.usePriority(audioPriority);
    }

    public void useVideoPriority() {
        this.usePriority(videoPriority);
    }

    public void useNetworkPriority() {
        this.usePriority(networkPriority);
    }

    public void useVideoNetworkPriority() {
        this.usePriority(videoNetworkPriority);
    }

    public static int getControlPriority() {
        return controlPriority;
    }

    public static int getAudioPriority() {
        return audioPriority;
    }

    public static int getVideoPriority() {
        return videoPriority;
    }

    public static int getNetworkPriority() {
        return networkPriority;
    }

    public static int getVideoNetworkPriority() {
        return videoNetworkPriority;
    }

    private void usePriority(int priority) {
        try {
            this.setPriority(priority);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkPriority(String name, int ask, boolean priv, int got) {
        if (ask != got) {
            System.out.println("MediaThread: " + name + " privilege? " + priv + "  ask pri: " + ask + " got pri:  " + got);
        }
    }

    static {
        block14: {
            securityPrivilege = true;
            controlPriority = 9;
            audioPriority = 5;
            videoPriority = 3;
            networkPriority = audioPriority + 1;
            videoNetworkPriority = networkPriority - 1;
            defaultMaxPriority = 4;
            JMFSecurity jmfSecurity = null;
            Method[] m2 = new Method[1];
            Class[] cl = new Class[1];
            Object[][] args = new Object[1][0];
            try {
                jmfSecurity = JMFSecurityManager.getJMFSecurity();
                if (jmfSecurity == null) break block14;
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    boolean haveBoth = true;
                    defaultMaxPriority = Thread.currentThread().getPriority();
                    try {
                        jmfSecurity.requestPermission(m2, cl, args, 16);
                        m2[0].invoke((Object)cl[0], args[0]);
                    }
                    catch (Throwable t) {
                        jmfSecurity.permissionFailureNotification(16);
                        haveBoth = false;
                    }
                    if (haveBoth) {
                        defaultMaxPriority = Thread.currentThread().getThreadGroup().getMaxPriority();
                    }
                    try {
                        jmfSecurity.requestPermission(m2, cl, args, 32);
                        m2[0].invoke((Object)cl[0], args[0]);
                    }
                    catch (Throwable t) {
                        jmfSecurity.permissionFailureNotification(32);
                        haveBoth = false;
                    }
                    if (!haveBoth) {
                        throw new Exception("No thread and or threadgroup permission");
                    }
                    break block14;
                }
                if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                } else if (jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor cons = jdk12Action.getCheckPermissionAction();
                    defaultMaxPriority = Thread.currentThread().getPriority();
                    jdk12.doPrivContextM.invoke((Object)jdk12.ac, cons.newInstance(JDK12Security.getThreadPermission()), jdk12.getContextM.invoke(null, null));
                    defaultMaxPriority = Thread.currentThread().getThreadGroup().getMaxPriority();
                    jdk12.doPrivContextM.invoke((Object)jdk12.ac, cons.newInstance(JDK12Security.getThreadGroupPermission()), jdk12.getContextM.invoke(null, null));
                } else if (jmfSecurity.getName().startsWith("default") && MediaThread.class.getClassLoader() != null) {
                    throw new SecurityException();
                }
            }
            catch (Throwable e2) {
                securityPrivilege = false;
                controlPriority = defaultMaxPriority;
                audioPriority = defaultMaxPriority;
                videoPriority = defaultMaxPriority - 1;
                networkPriority = defaultMaxPriority;
                videoNetworkPriority = defaultMaxPriority;
            }
        }
        threadGroup = securityPrivilege ? MediaThread.getRootThreadGroup() : null;
    }
}

