/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.FormatTable;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PropertyAction;
import com.sun.media.util.jdk12ReadFileAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;

public class Resource {
    private static Hashtable hash = null;
    private static String filename = null;
    private static final int versionNumber = 200;
    private static boolean securityPrivelege = false;
    private static JMFSecurity jmfSecurity = null;
    private static Method[] m = new Method[1];
    private static Class[] cl = new Class[1];
    private static Object[][] args = new Object[1][0];
    private static final String USERHOME = "user.home";
    private static String userhome = null;
    static FormatTable audioFmtTbl;
    static FormatTable videoFmtTbl;
    static FormatTable miscFmtTbl;
    static Object fmtTblSync;
    static int AUDIO_TBL_SIZE;
    static int VIDEO_TBL_SIZE;
    static int MISC_TBL_SIZE;
    static String AUDIO_SIZE_KEY;
    static String AUDIO_INPUT_KEY;
    static String AUDIO_FORMAT_KEY;
    static String AUDIO_HIT_KEY;
    static String VIDEO_SIZE_KEY;
    static String VIDEO_INPUT_KEY;
    static String VIDEO_FORMAT_KEY;
    static String VIDEO_HIT_KEY;
    static String MISC_SIZE_KEY;
    static String MISC_INPUT_KEY;
    static String MISC_FORMAT_KEY;
    static String MISC_HIT_KEY;
    static boolean needSaving;

    public static final synchronized void reset() {
        hash = new Hashtable();
    }

    public static final synchronized boolean set(String key, Object value) {
        if (key != null && value != null) {
            if (jmfSecurity != null && key.indexOf("secure.") == 0) {
                return false;
            }
            hash.put(key, value);
            return true;
        }
        return false;
    }

    public static final synchronized Object get(String key) {
        if (key != null) {
            return hash.get(key);
        }
        return null;
    }

    public static final synchronized boolean remove(String key) {
        if (key != null && hash.containsKey(key)) {
            hash.remove(key);
            return true;
        }
        return false;
    }

    public static final synchronized void removeGroup(String keyStart) {
        Vector<String> keys = new Vector<String>();
        if (keyStart != null) {
            Enumeration e2 = hash.keys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                if (!key.startsWith(keyStart)) continue;
                keys.addElement(key);
            }
        }
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            hash.remove(keys.elementAt(i2));
        }
    }

    public static final synchronized boolean commit() throws IOException {
        if (filename == null) {
            throw new IOException("Can't find resource file");
        }
        FileOutputStream fos = new FileOutputStream(filename);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        int tableSize = hash.size();
        oos.writeInt(tableSize);
        oos.writeInt(200);
        Enumeration e2 = hash.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            Object value = hash.get(key);
            oos.writeUTF(key);
            oos.writeObject(value);
            oos.flush();
        }
        oos.close();
        return true;
    }

    public static final synchronized void destroy() {
        if (filename == null) {
            return;
        }
        try {
            File file = new File(filename);
            file.delete();
        }
        catch (Throwable t) {
            filename = null;
        }
    }

    private static final synchronized InputStream findResourceFile() {
        String strJMF = ".jmf-resource";
        File file = null;
        FileInputStream ris = null;
        if (userhome == null) {
            return null;
        }
        try {
            filename = userhome + File.separator + strJMF;
            file = new File(filename);
            ris = Resource.getResourceStream(file);
        }
        catch (Throwable t) {
            filename = null;
            return null;
        }
        return ris;
    }

    private static final FileInputStream getResourceStream(File file) throws IOException {
        try {
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                Constructor cons = jdk12ReadFileAction.cons;
                return (FileInputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(file.getPath()));
            }
            if (!file.exists()) {
                return null;
            }
            return new FileInputStream(file.getPath());
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static final synchronized boolean readResource(InputStream ris) {
        if (ris == null) {
            return false;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(ris);
            int tableSize = ois.readInt();
            int version = ois.readInt();
            if (version > 200) {
                System.err.println("Version number mismatch.\nThere could be errors in reading the resource");
            }
            hash = new Hashtable();
            for (int i2 = 0; i2 < tableSize; ++i2) {
                String key = ois.readUTF();
                boolean failed = false;
                try {
                    Object value = ois.readObject();
                    hash.put(key, value);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    failed = true;
                    continue;
                }
                catch (OptionalDataException ode) {
                    failed = true;
                }
            }
            ois.close();
            ris.close();
        }
        catch (IOException ioe) {
            System.err.println("IOException in readResource: " + ioe);
        }
        finally {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void initDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            audioFmtTbl = new FormatTable(AUDIO_TBL_SIZE);
            videoFmtTbl = new FormatTable(VIDEO_TBL_SIZE);
            miscFmtTbl = new FormatTable(MISC_TBL_SIZE);
            Resource.loadDB();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void purgeDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            if (audioFmtTbl == null) {
                return;
            }
            audioFmtTbl = new FormatTable(AUDIO_TBL_SIZE);
            videoFmtTbl = new FormatTable(VIDEO_TBL_SIZE);
            miscFmtTbl = new FormatTable(MISC_TBL_SIZE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Format[] getDB(Format input) {
        Object object = fmtTblSync;
        synchronized (object) {
            if (audioFmtTbl == null) {
                Resource.initDB();
            }
            if (input instanceof AudioFormat) {
                return audioFmtTbl.get(input);
            }
            if (input instanceof VideoFormat) {
                return videoFmtTbl.get(input);
            }
            return miscFmtTbl.get(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Format[] putDB(Format input, Format[] supported) {
        Object object = fmtTblSync;
        synchronized (object) {
            Format in = input.relax();
            Format[] list = new Format[supported.length];
            for (int i2 = 0; i2 < supported.length; ++i2) {
                list[i2] = supported[i2].relax();
            }
            if (in instanceof AudioFormat) {
                audioFmtTbl.save(in, list);
            } else if (in instanceof VideoFormat) {
                videoFmtTbl.save(in, list);
            } else {
                miscFmtTbl.save(in, list);
            }
            needSaving = true;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            Object hit;
            Object value;
            int i2;
            Object key = Resource.get(AUDIO_SIZE_KEY);
            int size = key instanceof Integer ? (Integer)key : 0;
            if (size > AUDIO_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                size = AUDIO_TBL_SIZE;
            }
            Resource.audioFmtTbl.last = size;
            for (i2 = 0; i2 < size; ++i2) {
                key = Resource.get(AUDIO_INPUT_KEY + i2);
                value = Resource.get(AUDIO_FORMAT_KEY + i2);
                hit = Resource.get(AUDIO_HIT_KEY + i2);
                if (!(key instanceof Format && value instanceof Format[] && hit instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.audioFmtTbl.last = 0;
                    break;
                }
                Resource.audioFmtTbl.keys[i2] = (Format)key;
                Resource.audioFmtTbl.table[i2] = (Format[])value;
                Resource.audioFmtTbl.hits[i2] = (Integer)hit;
            }
            if ((size = (key = Resource.get(VIDEO_SIZE_KEY)) instanceof Integer ? (Integer)key : 0) > VIDEO_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                size = VIDEO_TBL_SIZE;
            }
            Resource.videoFmtTbl.last = size;
            for (i2 = 0; i2 < size; ++i2) {
                key = Resource.get(VIDEO_INPUT_KEY + i2);
                value = Resource.get(VIDEO_FORMAT_KEY + i2);
                hit = Resource.get(VIDEO_HIT_KEY + i2);
                if (!(key instanceof Format && value instanceof Format[] && hit instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.videoFmtTbl.last = 0;
                    break;
                }
                Resource.videoFmtTbl.keys[i2] = (Format)key;
                Resource.videoFmtTbl.table[i2] = (Format[])value;
                Resource.videoFmtTbl.hits[i2] = (Integer)hit;
            }
            if ((size = (key = Resource.get(MISC_SIZE_KEY)) instanceof Integer ? (Integer)key : 0) > MISC_TBL_SIZE) {
                System.err.println("Resource file is corrupted");
                size = MISC_TBL_SIZE;
            }
            Resource.miscFmtTbl.last = size;
            for (i2 = 0; i2 < size; ++i2) {
                key = Resource.get(MISC_INPUT_KEY + i2);
                value = Resource.get(MISC_FORMAT_KEY + i2);
                hit = Resource.get(MISC_HIT_KEY + i2);
                if (!(key instanceof Format && value instanceof Format[] && hit instanceof Integer)) {
                    System.err.println("Resource file is corrupted");
                    Resource.miscFmtTbl.last = 0;
                    break;
                }
                Resource.miscFmtTbl.keys[i2] = (Format)key;
                Resource.miscFmtTbl.table[i2] = (Format[])value;
                Resource.miscFmtTbl.hits[i2] = (Integer)hit;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveDB() {
        Object object = fmtTblSync;
        synchronized (object) {
            int i2;
            if (!needSaving) {
                return;
            }
            Resource.reset();
            Resource.set(AUDIO_SIZE_KEY, new Integer(Resource.audioFmtTbl.last));
            for (i2 = 0; i2 < Resource.audioFmtTbl.last; ++i2) {
                Resource.set(AUDIO_INPUT_KEY + i2, Resource.audioFmtTbl.keys[i2]);
                Resource.set(AUDIO_FORMAT_KEY + i2, Resource.audioFmtTbl.table[i2]);
                Resource.set(AUDIO_HIT_KEY + i2, new Integer(Resource.audioFmtTbl.hits[i2]));
            }
            Resource.set(VIDEO_SIZE_KEY, new Integer(Resource.videoFmtTbl.last));
            for (i2 = 0; i2 < Resource.videoFmtTbl.last; ++i2) {
                Resource.set(VIDEO_INPUT_KEY + i2, Resource.videoFmtTbl.keys[i2]);
                Resource.set(VIDEO_FORMAT_KEY + i2, Resource.videoFmtTbl.table[i2]);
                Resource.set(VIDEO_HIT_KEY + i2, new Integer(Resource.videoFmtTbl.hits[i2]));
            }
            Resource.set(MISC_SIZE_KEY, new Integer(Resource.miscFmtTbl.last));
            for (i2 = 0; i2 < Resource.miscFmtTbl.last; ++i2) {
                Resource.set(MISC_INPUT_KEY + i2, Resource.miscFmtTbl.keys[i2]);
                Resource.set(MISC_FORMAT_KEY + i2, Resource.miscFmtTbl.table[i2]);
                Resource.set(MISC_HIT_KEY + i2, new Integer(Resource.miscFmtTbl.hits[i2]));
            }
            try {
                Resource.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            needSaving = false;
        }
    }

    static {
        hash = new Hashtable();
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "read property";
                    jmfSecurity.requestPermission(m, cl, args, 1);
                    m[0].invoke((Object)cl[0], args[0]);
                    permission = "read file";
                    jmfSecurity.requestPermission(m, cl, args, 2);
                    m[0].invoke((Object)cl[0], args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.checkPermission((PermissionID)PermissionID.FILEIO);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.PROPERTY);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.FILEIO);
                }
            }
            catch (Throwable e3) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = jdk12PropertyAction.cons;
                userhome = (String)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(USERHOME));
            }
            catch (Throwable e4) {
                securityPrivelege = false;
            }
        } else {
            try {
                if (securityPrivelege) {
                    userhome = System.getProperty(USERHOME);
                }
            }
            catch (Exception e5) {
                userhome = null;
                securityPrivelege = false;
            }
        }
        if (userhome == null) {
            securityPrivelege = false;
        }
        InputStream is = null;
        if (securityPrivelege && (is = Resource.findResourceFile()) == null) {
            securityPrivelege = false;
        }
        if (!Resource.readResource(is)) {
            hash = new Hashtable();
        }
        fmtTblSync = new Object();
        AUDIO_TBL_SIZE = 40;
        VIDEO_TBL_SIZE = 20;
        MISC_TBL_SIZE = 10;
        AUDIO_SIZE_KEY = "ATS";
        AUDIO_INPUT_KEY = "AI.";
        AUDIO_FORMAT_KEY = "AF.";
        AUDIO_HIT_KEY = "AH.";
        VIDEO_SIZE_KEY = "VTS";
        VIDEO_INPUT_KEY = "VI.";
        VIDEO_FORMAT_KEY = "VF.";
        VIDEO_HIT_KEY = "VH.";
        MISC_SIZE_KEY = "MTS";
        MISC_INPUT_KEY = "MI.";
        MISC_FORMAT_KEY = "MF.";
        MISC_HIT_KEY = "MH.";
        needSaving = false;
    }
}

