/*
 * Decompiled with CFR 0.152.
 */
package jmapps.export;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.util.JMAppsCfg;

public class PanelMediaTargetNetwork
extends JMPanel
implements TextListener,
FocusListener {
    private JMAppsCfg cfgJMApps = null;
    private Panel panelLabels;
    private Panel panelAddress;
    private Panel panelPort;
    private Panel panelTtl;
    private TextField[][] arrTextVideoTrackAddress = null;
    private TextField[][] arrTextAudioTrackAddress = null;
    private TextField[] arrTextVideoPort = null;
    private TextField[] arrTextAudioPort = null;
    private Choice[] arrComboVideoTtl = null;
    private Choice[] arrComboAudioTtl = null;
    private int nVideoCount = 0;
    private int nAudioCount = 0;
    private static final int MAX_TRACK_COUNT = 8;

    public PanelMediaTargetNetwork(JMAppsCfg cfgJMApps) {
        this.cfgJMApps = cfgJMApps;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setJMStudioCfg(JMAppsCfg cfgJMApps) {
        this.cfgJMApps = cfgJMApps;
        if (cfgJMApps == null) {
            return;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            JMAppsCfg.RtpData dataRtp = cfgJMApps.getLastTransmitRtpData("Video " + (i2 + 1));
            if (dataRtp != null) {
                this.arrTextVideoTrackAddress[i2][0].setText(dataRtp.strAddress0);
                this.arrTextVideoTrackAddress[i2][1].setText(dataRtp.strAddress1);
                this.arrTextVideoTrackAddress[i2][2].setText(dataRtp.strAddress2);
                this.arrTextVideoTrackAddress[i2][3].setText(dataRtp.strAddress3);
                this.arrTextVideoPort[i2].setText(dataRtp.strPort);
                this.arrComboVideoTtl[i2].select(dataRtp.strTtl);
            }
            if ((dataRtp = cfgJMApps.getLastTransmitRtpData("Audio " + (i2 + 1))) == null) continue;
            this.arrTextAudioTrackAddress[i2][0].setText(dataRtp.strAddress0);
            this.arrTextAudioTrackAddress[i2][1].setText(dataRtp.strAddress1);
            this.arrTextAudioTrackAddress[i2][2].setText(dataRtp.strAddress2);
            this.arrTextAudioTrackAddress[i2][3].setText(dataRtp.strAddress3);
            this.arrTextAudioPort[i2].setText(dataRtp.strPort);
            this.arrComboAudioTtl[i2].select(dataRtp.strTtl);
        }
    }

    public String[] getVideoAddresses() {
        String[] arrValues = new String[this.nVideoCount];
        for (int i2 = 0; i2 < this.nVideoCount; ++i2) {
            arrValues[i2] = this.arrTextVideoTrackAddress[i2][0].getText().trim();
            for (int j2 = 1; j2 < 4; ++j2) {
                arrValues[i2] = arrValues[i2] + "." + this.arrTextVideoTrackAddress[i2][j2].getText().trim();
            }
        }
        return arrValues;
    }

    public String[] getAudioAddresses() {
        String[] arrValues = new String[this.nAudioCount];
        for (int i2 = 0; i2 < this.nAudioCount; ++i2) {
            arrValues[i2] = this.arrTextAudioTrackAddress[i2][0].getText().trim();
            for (int j2 = 1; j2 < 4; ++j2) {
                arrValues[i2] = arrValues[i2] + "." + this.arrTextAudioTrackAddress[i2][j2].getText().trim();
            }
        }
        return arrValues;
    }

    public String[] getVideoPorts() {
        String[] arrValues = new String[this.nVideoCount];
        for (int i2 = 0; i2 < this.nVideoCount; ++i2) {
            arrValues[i2] = this.arrTextVideoPort[i2].getText().trim();
        }
        return arrValues;
    }

    public String[] getAudioPorts() {
        String[] arrValues = new String[this.nAudioCount];
        for (int i2 = 0; i2 < this.nAudioCount; ++i2) {
            arrValues[i2] = this.arrTextAudioPort[i2].getText().trim();
        }
        return arrValues;
    }

    public String[] getVideoTtls() {
        String[] arrValues = new String[this.nVideoCount];
        for (int i2 = 0; i2 < this.nVideoCount; ++i2) {
            arrValues[i2] = this.arrComboVideoTtl[i2].getSelectedItem().trim();
        }
        return arrValues;
    }

    public String[] getAudioTtls() {
        String[] arrValues = new String[this.nAudioCount];
        for (int i2 = 0; i2 < this.nAudioCount; ++i2) {
            arrValues[i2] = this.arrComboAudioTtl[i2].getSelectedItem().trim();
        }
        return arrValues;
    }

    private void init() throws Exception {
        this.setLayout(new BorderLayout(6, 6));
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.add((Component)panel, "North");
        Panel panelDescription = new Panel(new GridLayout(0, 1));
        panel.add((Component)panelDescription, "North");
        panelDescription.add(new Label(JMFI18N.getResource("jmstudio.export.targetnw.label1")));
        panelDescription.add(new Label(JMFI18N.getResource("jmstudio.export.targetnw.label2")));
        this.panelLabels = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)this.panelLabels, "West");
        this.panelAddress = new Panel(new GridLayout(0, 1, 6, 6));
        panel.add((Component)this.panelAddress, "Center");
        Panel panelTemp = new Panel(new BorderLayout(6, 6));
        panel.add((Component)panelTemp, "East");
        this.panelPort = new Panel(new GridLayout(0, 1, 6, 6));
        panelTemp.add((Component)this.panelPort, "Center");
        this.panelTtl = new Panel(new GridLayout(0, 1, 6, 6));
        panelTemp.add((Component)this.panelTtl, "East");
        this.arrTextVideoTrackAddress = new TextField[8][4];
        this.arrTextAudioTrackAddress = new TextField[8][4];
        this.arrTextVideoPort = new TextField[8];
        this.arrTextAudioPort = new TextField[8];
        this.arrComboVideoTtl = new Choice[8];
        this.arrComboAudioTtl = new Choice[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                this.arrTextVideoTrackAddress[i2][j2] = new TextField();
                this.arrTextVideoTrackAddress[i2][j2].addTextListener(this);
                this.arrTextVideoTrackAddress[i2][j2].addFocusListener(this);
                this.arrTextAudioTrackAddress[i2][j2] = new TextField();
                this.arrTextAudioTrackAddress[i2][j2].addTextListener(this);
                this.arrTextAudioTrackAddress[i2][j2].addFocusListener(this);
            }
            this.arrTextVideoPort[i2] = new TextField(5);
            this.arrTextVideoPort[i2].addFocusListener(this);
            this.arrTextAudioPort[i2] = new TextField(5);
            this.arrTextAudioPort[i2].addFocusListener(this);
            this.arrComboVideoTtl[i2] = new Choice();
            this.arrComboVideoTtl[i2].addItem("1");
            this.arrComboVideoTtl[i2].addItem("2");
            this.arrComboVideoTtl[i2].addItem("3");
            this.arrComboVideoTtl[i2].addItem("4");
            this.arrComboVideoTtl[i2].addItem("8");
            this.arrComboVideoTtl[i2].addItem("16");
            this.arrComboVideoTtl[i2].addItem("32");
            this.arrComboVideoTtl[i2].addItem("64");
            this.arrComboVideoTtl[i2].addItem("128");
            this.arrComboVideoTtl[i2].addItem("255");
            this.arrComboAudioTtl[i2] = new Choice();
            this.arrComboAudioTtl[i2].addItem("1");
            this.arrComboAudioTtl[i2].addItem("2");
            this.arrComboAudioTtl[i2].addItem("3");
            this.arrComboAudioTtl[i2].addItem("4");
            this.arrComboAudioTtl[i2].addItem("8");
            this.arrComboAudioTtl[i2].addItem("16");
            this.arrComboAudioTtl[i2].addItem("32");
            this.arrComboAudioTtl[i2].addItem("64");
            this.arrComboAudioTtl[i2].addItem("128");
            this.arrComboAudioTtl[i2].addItem("255");
            if (this.cfgJMApps == null) continue;
            JMAppsCfg.RtpData dataRtp = this.cfgJMApps.getLastTransmitRtpData("Video " + (i2 + 1));
            if (dataRtp != null) {
                this.arrTextVideoTrackAddress[i2][0].setText(dataRtp.strAddress0);
                this.arrTextVideoTrackAddress[i2][1].setText(dataRtp.strAddress1);
                this.arrTextVideoTrackAddress[i2][2].setText(dataRtp.strAddress2);
                this.arrTextVideoTrackAddress[i2][3].setText(dataRtp.strAddress3);
                this.arrTextVideoPort[i2].setText(dataRtp.strPort);
                this.arrComboVideoTtl[i2].select(dataRtp.strTtl);
            }
            if ((dataRtp = this.cfgJMApps.getLastTransmitRtpData("Audio " + (i2 + 1))) == null) continue;
            this.arrTextAudioTrackAddress[i2][0].setText(dataRtp.strAddress0);
            this.arrTextAudioTrackAddress[i2][1].setText(dataRtp.strAddress1);
            this.arrTextAudioTrackAddress[i2][2].setText(dataRtp.strAddress2);
            this.arrTextAudioTrackAddress[i2][3].setText(dataRtp.strAddress3);
            this.arrTextAudioPort[i2].setText(dataRtp.strPort);
            this.arrComboAudioTtl[i2].select(dataRtp.strTtl);
        }
    }

    public void setTracks(boolean[] arrVideoTracksEnabled, boolean[] arrAudioTracksEnabled) {
        int j2;
        Panel panelAddressEntry;
        int i2;
        String strAudio = JMFI18N.getResource("jmstudio.export.targetnw.audio");
        String strVideo = JMFI18N.getResource("jmstudio.export.targetnw.video");
        this.nVideoCount = arrVideoTracksEnabled.length;
        this.nAudioCount = arrAudioTracksEnabled.length;
        this.panelLabels.removeAll();
        this.panelAddress.removeAll();
        this.panelPort.removeAll();
        this.panelTtl.removeAll();
        Label label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.track"), 1);
        this.panelLabels.add(label);
        label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.sessionaddr"), 1);
        this.panelAddress.add(label);
        label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.port"), 1);
        this.panelPort.add(label);
        label = new Label(JMFI18N.getResource("jmstudio.export.targetnw.ttl"), 1);
        this.panelTtl.add(label);
        for (i2 = 0; i2 < this.nVideoCount; ++i2) {
            label = new Label(strVideo + " " + (i2 + 1), 0);
            label.setEnabled(arrVideoTracksEnabled[i2]);
            this.panelLabels.add(label);
            panelAddressEntry = new Panel(new GridLayout(1, 0, 2, 2));
            this.panelAddress.add(panelAddressEntry);
            for (j2 = 0; j2 < 4; ++j2) {
                this.arrTextVideoTrackAddress[i2][j2].setEnabled(arrVideoTracksEnabled[i2]);
                panelAddressEntry.add(this.arrTextVideoTrackAddress[i2][j2]);
            }
            this.arrTextVideoPort[i2].setEnabled(arrVideoTracksEnabled[i2]);
            this.panelPort.add(this.arrTextVideoPort[i2]);
            this.arrComboVideoTtl[i2].setEnabled(arrVideoTracksEnabled[i2]);
            this.panelTtl.add(this.arrComboVideoTtl[i2]);
        }
        for (i2 = 0; i2 < this.nAudioCount; ++i2) {
            label = new Label(strAudio + " " + (i2 + 1), 0);
            label.setEnabled(arrAudioTracksEnabled[i2]);
            this.panelLabels.add(label);
            panelAddressEntry = new Panel(new GridLayout(1, 0, 2, 2));
            this.panelAddress.add(panelAddressEntry);
            for (j2 = 0; j2 < 4; ++j2) {
                this.arrTextAudioTrackAddress[i2][j2].setEnabled(arrAudioTracksEnabled[i2]);
                panelAddressEntry.add(this.arrTextAudioTrackAddress[i2][j2]);
            }
            this.arrTextAudioPort[i2].setEnabled(arrAudioTracksEnabled[i2]);
            this.panelPort.add(this.arrTextAudioPort[i2]);
            this.arrComboAudioTtl[i2].setEnabled(arrAudioTracksEnabled[i2]);
            this.panelTtl.add(this.arrComboAudioTtl[i2]);
        }
    }

    public void textValueChanged(TextEvent event) {
        TextField textField;
        String strValue;
        Object objectSource = event.getSource();
        if (objectSource instanceof TextField && (strValue = (textField = (TextField)objectSource).getText()).length() > 2) {
            textField.transferFocus();
        }
    }

    public boolean checkValidFields(boolean boolDisplayMessage) {
        int nValue;
        String strValue;
        int j2;
        int i2;
        for (i2 = 0; i2 < this.nVideoCount; ++i2) {
            for (j2 = 0; j2 < 4; ++j2) {
                if (!this.arrTextVideoTrackAddress[i2][j2].isEnabled()) continue;
                strValue = this.arrTextVideoTrackAddress[i2][j2].getText();
                try {
                    nValue = Integer.valueOf(strValue);
                }
                catch (Exception exception) {
                    nValue = -1;
                }
                if (nValue >= 0 && nValue <= 255) continue;
                if (boolDisplayMessage) {
                    MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.video.sessionaddr") + " " + (i2 + 1));
                }
                return false;
            }
            if (!this.arrTextVideoPort[i2].isEnabled()) continue;
            strValue = this.arrTextVideoPort[i2].getText();
            try {
                nValue = Integer.valueOf(strValue);
            }
            catch (Exception exception) {
                nValue = -1;
            }
            if (nValue >= 0 && (nValue & 1) != 1) continue;
            if (boolDisplayMessage) {
                MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.video.port") + " " + (i2 + 1));
            }
            return false;
        }
        for (i2 = 0; i2 < this.nAudioCount; ++i2) {
            for (j2 = 0; j2 < 4; ++j2) {
                if (!this.arrTextAudioTrackAddress[i2][j2].isEnabled()) continue;
                strValue = this.arrTextAudioTrackAddress[i2][j2].getText();
                try {
                    nValue = Integer.valueOf(strValue);
                }
                catch (Exception exception) {
                    nValue = -1;
                }
                if (nValue >= 0 && nValue <= 255) continue;
                if (boolDisplayMessage) {
                    MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.audio.sessionaddr") + " " + (i2 + 1));
                }
                return false;
            }
            if (!this.arrTextAudioPort[i2].isEnabled()) continue;
            strValue = this.arrTextAudioPort[i2].getText();
            try {
                nValue = Integer.valueOf(strValue);
            }
            catch (Exception exception) {
                nValue = -1;
            }
            if (nValue >= 0 && (nValue & 1) != 1) continue;
            if (boolDisplayMessage) {
                MessageDialog.createErrorDialog(this.getFrame(), JMFI18N.getResource("jmstudio.error.audio.port") + " " + (i2 + 1));
            }
            return false;
        }
        return true;
    }

    public void saveData() {
        if (this.cfgJMApps == null) {
            return;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            JMAppsCfg.RtpData dataRtp = this.cfgJMApps.createRtpDataObject();
            dataRtp.strAddress0 = this.arrTextVideoTrackAddress[i2][0].getText();
            dataRtp.strAddress1 = this.arrTextVideoTrackAddress[i2][1].getText();
            dataRtp.strAddress2 = this.arrTextVideoTrackAddress[i2][2].getText();
            dataRtp.strAddress3 = this.arrTextVideoTrackAddress[i2][3].getText();
            dataRtp.strPort = this.arrTextVideoPort[i2].getText();
            dataRtp.strTtl = this.arrComboVideoTtl[i2].getSelectedItem();
            this.cfgJMApps.setLastTransmitRtpData(dataRtp, "Video " + (i2 + 1));
            dataRtp = this.cfgJMApps.createRtpDataObject();
            dataRtp.strAddress0 = this.arrTextAudioTrackAddress[i2][0].getText();
            dataRtp.strAddress1 = this.arrTextAudioTrackAddress[i2][1].getText();
            dataRtp.strAddress2 = this.arrTextAudioTrackAddress[i2][2].getText();
            dataRtp.strAddress3 = this.arrTextAudioTrackAddress[i2][3].getText();
            dataRtp.strPort = this.arrTextAudioPort[i2].getText();
            dataRtp.strTtl = this.arrComboAudioTtl[i2].getSelectedItem();
            this.cfgJMApps.setLastTransmitRtpData(dataRtp, "Audio " + (i2 + 1));
        }
    }

    public void focusGained(FocusEvent fe) {
        Object source = fe.getSource();
        if (source instanceof TextField) {
            ((TextField)source).selectAll();
        }
    }

    public void focusLost(FocusEvent fe) {
        Object source = fe.getSource();
        if (source instanceof TextField) {
            ((TextField)source).select(1, 0);
        }
    }
}

