/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.SessionManager;
import jmapps.ui.JMPanel;

public class ViewParticipantList
extends JMPanel {
    public static final String PARTICIPANTS = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants");
    public static final String NONE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.none");
    public static final String REMOTE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.remote");
    public static final String LOCAL = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.local");
    public static final String PASSIVE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.passive");
    public static final String ACTIVE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.active");
    private SessionManager mngrSession;
    private List listParticipantsRemote;
    private List listParticipantsLocal;
    private List listParticipantsActive;
    private List listParticipantsPassive;
    private Vector lastRemoteList = new Vector();
    private Vector lastLocalList = new Vector();
    private Vector lastActiveList = new Vector();
    private Vector lastPassiveList = new Vector();
    long lastCheckTime = -1L;

    public ViewParticipantList(SessionManager mngrSession) {
        this.mngrSession = mngrSession;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.setLayout(new GridLayout(0, 1, 6, 6));
        JMPanel panel = new JMPanel(new BorderLayout());
        this.add(panel);
        Label label = new Label(REMOTE + ":");
        panel.add((Component)label, "North");
        this.listParticipantsRemote = new List();
        panel.add((Component)this.listParticipantsRemote, "Center");
        panel = new JMPanel(new BorderLayout());
        this.add(panel);
        label = new Label(LOCAL + ":");
        panel.add((Component)label, "North");
        this.listParticipantsLocal = new List();
        panel.add((Component)this.listParticipantsLocal, "Center");
        panel = new JMPanel(new BorderLayout());
        this.add(panel);
        label = new Label(ACTIVE + ":");
        panel.add((Component)label, "North");
        this.listParticipantsActive = new List();
        panel.add((Component)this.listParticipantsActive, "Center");
        panel = new JMPanel(new BorderLayout());
        this.add(panel);
        label = new Label(PASSIVE + ":");
        panel.add((Component)label, "North");
        this.listParticipantsPassive = new List();
        panel.add((Component)this.listParticipantsPassive, "Center");
        this.updateFields();
    }

    boolean compare(Vector list1, Vector list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list1.size(); ++i2) {
            if (list2.contains(list1.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public void updateFields() {
        int j2;
        Object objParticipant;
        int i2;
        int nCount;
        long now = System.currentTimeMillis();
        if (now - this.lastCheckTime < 3000L) {
            return;
        }
        this.lastCheckTime = now;
        Vector vectorParticipants = ViewParticipantList.getParticipants(this.mngrSession, REMOTE);
        if (!this.compare(this.lastRemoteList, vectorParticipants)) {
            if (this.listParticipantsRemote.getItemCount() > 0) {
                this.listParticipantsRemote.removeAll();
            }
            nCount = vectorParticipants.size();
            for (i2 = 0; i2 < nCount; ++i2) {
                objParticipant = vectorParticipants.elementAt(i2);
                if (objParticipant == null || !(objParticipant instanceof Participant)) continue;
                this.listParticipantsRemote.add(((Participant)objParticipant).getCNAME());
            }
            if (nCount < 1) {
                this.listParticipantsRemote.add(NONE);
            }
            this.lastRemoteList.removeAllElements();
            for (j2 = 0; j2 < vectorParticipants.size(); ++j2) {
                this.lastRemoteList.addElement(vectorParticipants.elementAt(j2));
            }
        }
        if (!this.compare(this.lastLocalList, vectorParticipants = ViewParticipantList.getParticipants(this.mngrSession, LOCAL))) {
            if (this.listParticipantsLocal.getItemCount() > 0) {
                this.listParticipantsLocal.removeAll();
            }
            nCount = vectorParticipants.size();
            for (i2 = 0; i2 < nCount; ++i2) {
                objParticipant = vectorParticipants.elementAt(i2);
                if (objParticipant == null || !(objParticipant instanceof Participant)) continue;
                this.listParticipantsLocal.add(((Participant)objParticipant).getCNAME());
            }
            if (nCount < 1) {
                this.listParticipantsLocal.add(NONE);
            }
            this.lastLocalList.removeAllElements();
            for (j2 = 0; j2 < vectorParticipants.size(); ++j2) {
                this.lastLocalList.addElement(vectorParticipants.elementAt(j2));
            }
        }
        if (!this.compare(this.lastActiveList, vectorParticipants = ViewParticipantList.getParticipants(this.mngrSession, ACTIVE))) {
            if (this.listParticipantsActive.getItemCount() > 0) {
                this.listParticipantsActive.removeAll();
            }
            nCount = vectorParticipants.size();
            for (i2 = 0; i2 < nCount; ++i2) {
                objParticipant = vectorParticipants.elementAt(i2);
                if (objParticipant == null || !(objParticipant instanceof Participant)) continue;
                this.listParticipantsActive.add(((Participant)objParticipant).getCNAME());
            }
            if (nCount < 1) {
                this.listParticipantsActive.add(NONE);
            }
            this.lastActiveList.removeAllElements();
            for (j2 = 0; j2 < vectorParticipants.size(); ++j2) {
                this.lastActiveList.addElement(vectorParticipants.elementAt(j2));
            }
        }
        if (!this.compare(this.lastPassiveList, vectorParticipants = ViewParticipantList.getParticipants(this.mngrSession, PASSIVE))) {
            if (this.listParticipantsPassive.getItemCount() > 0) {
                this.listParticipantsPassive.removeAll();
            }
            nCount = vectorParticipants.size();
            for (i2 = 0; i2 < nCount; ++i2) {
                objParticipant = vectorParticipants.elementAt(i2);
                if (objParticipant == null || !(objParticipant instanceof Participant)) continue;
                this.listParticipantsPassive.add(((Participant)objParticipant).getCNAME());
            }
            if (nCount < 1) {
                this.listParticipantsPassive.add(NONE);
            }
            this.lastPassiveList.removeAllElements();
            for (j2 = 0; j2 < vectorParticipants.size(); ++j2) {
                this.lastPassiveList.addElement(vectorParticipants.elementAt(j2));
            }
        }
    }

    public static Vector getParticipants(SessionManager mngrSession, String strListType) {
        Vector vectorParticipants = null;
        if (strListType.equals(REMOTE)) {
            vectorParticipants = mngrSession.getRemoteParticipants();
        } else if (strListType.equals(LOCAL)) {
            vectorParticipants = new Vector();
            vectorParticipants.addElement(mngrSession.getLocalParticipant());
        } else if (strListType.equals(PASSIVE)) {
            vectorParticipants = mngrSession.getPassiveParticipants();
        } else if (strListType.equals(ACTIVE)) {
            vectorParticipants = mngrSession.getActiveParticipants();
        }
        return vectorParticipants;
    }
}

