/*
 * Decompiled with CFR 0.152.
 */
package jmapps.ui;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.lang.reflect.Method;
import java.net.URL;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DurationUpdateEvent;
import javax.media.MediaTimeSetEvent;
import javax.media.PrefetchCompleteEvent;
import javax.media.RateChangeEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import javax.media.TransitionEvent;
import javax.media.bean.playerbean.MediaPlayer;
import javax.media.format.FormatChangeEvent;
import javax.media.protocol.DataSource;
import jmapps.ui.ImageArea;
import jmapps.ui.JMFrame;
import jmapps.ui.JMPanel;
import jmapps.ui.MessageDialog;
import jmapps.ui.VideoPanel;
import jmapps.util.JMFUtils;

public class PlayerFrame
extends JMFrame
implements ActionListener,
ContainerListener,
ControllerListener {
    protected MediaPlayer mediaPlayerCurrent = null;
    protected JMPanel panelContent;
    protected Component compControl = null;
    protected VideoPanel panelVideo = null;
    protected ImageArea areaImagePlaceholder = null;
    protected Component progressBarCache = null;
    protected Cursor cursorNormal = new Cursor(0);
    protected Cursor cursorWait = new Cursor(3);
    protected boolean boolErrorClose = false;
    protected boolean boolMediaClosed = true;

    public PlayerFrame(Frame frameOwner, String strTitle) {
        super(frameOwner, strTitle);
    }

    protected void initFrame() {
        super.initFrame();
        this.setLayout(new BorderLayout());
        this.panelContent = new JMPanel(new BorderLayout());
        this.add((Component)this.panelContent, "Center");
        this.panelContent.addContainerListener(this);
        this.setPlaceholder();
    }

    public void open(String nameUrl) {
        MediaPlayer mediaPlayer = JMFUtils.createMediaPlayer(nameUrl, this, null, null);
        boolean boolResult = this.open(mediaPlayer);
    }

    public void open(DataSource dataSource) {
        MediaPlayer mediaPlayer = JMFUtils.createMediaPlayer(dataSource, (Frame)this);
        boolean boolResult = this.open(mediaPlayer);
    }

    public boolean open(MediaPlayer mediaPlayer) {
        if (mediaPlayer == null) {
            return false;
        }
        this.killCurrentPlayer();
        this.setCursor(this.cursorWait);
        this.mediaPlayerCurrent = mediaPlayer;
        mediaPlayer.setPopupActive(false);
        mediaPlayer.setControlPanelVisible(false);
        mediaPlayer.addControllerListener(this);
        mediaPlayer.realize();
        return true;
    }

    public void setPlaceholder() {
        Image image;
        if (this.areaImagePlaceholder == null && (image = ImageArea.loadImage("playerPlaceholder.gif", this, true)) != null) {
            this.areaImagePlaceholder = new ImageArea(image);
            this.areaImagePlaceholder.setInsets(0, 0, 0, 0);
        }
        if (this.areaImagePlaceholder != null) {
            this.panelContent.removeAll();
            this.panelContent.add((Component)this.areaImagePlaceholder, "Center");
        }
    }

    protected void killCurrentView() {
        this.panelVideo = null;
        this.compControl = null;
        int i2 = this.panelContent.getComponentCount();
        while (i2 > 0) {
            Component component;
            if ((component = this.panelContent.getComponent(--i2)) == this.areaImagePlaceholder) continue;
            this.panelContent.remove(component);
        }
    }

    protected void killCurrentPlayer() {
        this.killCurrentView();
        if (this.mediaPlayerCurrent != null) {
            this.boolMediaClosed = false;
            this.mediaPlayerCurrent.close();
            if (!this.boolErrorClose) {
                while (!this.boolMediaClosed) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {}
                }
            }
            this.mediaPlayerCurrent.removeControllerListener(this);
            this.mediaPlayerCurrent = null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        Object objSource = event.getSource();
        if (strCmd == null && objSource instanceof MenuItem) {
            strCmd = ((MenuItem)objSource).getActionCommand();
        }
        if (strCmd == null) {
            return;
        }
        if (strCmd.equals(VideoPanel.MENU_ZOOM_1_2)) {
            this.pack();
        } else if (strCmd.equals(VideoPanel.MENU_ZOOM_1_1)) {
            this.pack();
        } else if (strCmd.equals(VideoPanel.MENU_ZOOM_2_1)) {
            this.pack();
        } else if (strCmd.equals(VideoPanel.MENU_ZOOM_4_1)) {
            this.pack();
        }
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof RealizeCompleteEvent) {
            this.processRealizeComplete((RealizeCompleteEvent)event);
        } else if (event instanceof PrefetchCompleteEvent) {
            this.processPrefetchComplete((PrefetchCompleteEvent)event);
        } else if (event instanceof ControllerErrorEvent) {
            this.processControllerError((ControllerErrorEvent)event);
        } else if (event instanceof ControllerClosedEvent) {
            this.processControllerClosed((ControllerClosedEvent)event);
        } else if (event instanceof DurationUpdateEvent) {
            Time time = ((DurationUpdateEvent)event).getDuration();
        } else if (event instanceof CachingControlEvent) {
            this.processCachingControl((CachingControlEvent)event);
        } else if (!(event instanceof StartEvent || event instanceof MediaTimeSetEvent || event instanceof TransitionEvent || event instanceof RateChangeEvent || event instanceof StopTimeChangeEvent)) {
            if (event instanceof FormatChangeEvent) {
                this.processFormatChange((FormatChangeEvent)event);
            } else if (!(event instanceof SizeChangeEvent) && event.getClass().getName().endsWith("ReplaceURLEvent")) {
                this.processReplaceURL(event);
            }
        }
    }

    protected void processRealizeComplete(RealizeCompleteEvent event) {
        this.killCurrentView();
        this.setCursor(this.cursorNormal);
        this.panelVideo = new VideoPanel(this.mediaPlayerCurrent);
        this.panelVideo.setZoom(1.0);
        this.panelVideo.addMenuZoomActionListener(this);
        this.panelContent.add((Component)this.panelVideo, "Center");
        this.compControl = this.mediaPlayerCurrent.getControlPanelComponent();
        if (this.compControl != null) {
            this.panelContent.add(this.compControl, "South");
        }
        this.mediaPlayerCurrent.prefetch();
    }

    protected void processPrefetchComplete(PrefetchCompleteEvent event) {
        this.mediaPlayerCurrent.start();
    }

    protected void processControllerError(ControllerErrorEvent event) {
        this.setCursor(this.cursorNormal);
        String strMessage = JMFI18N.getResource("jmstudio.error.controller") + "\n" + event.getMessage();
        MessageDialog.createErrorDialogModeless(this, strMessage);
        if (this.boolMediaClosed) {
            this.boolErrorClose = true;
            this.killCurrentPlayer();
            this.boolErrorClose = false;
        }
        this.boolMediaClosed = true;
    }

    protected void processControllerClosed(ControllerClosedEvent event) {
        this.boolMediaClosed = true;
        this.setCursor(this.cursorNormal);
    }

    protected void processCachingControl(CachingControlEvent event) {
        Component progressBarCacheNew = null;
        CachingControl controlCaching = event.getCachingControl();
        if (controlCaching == null) {
            return;
        }
        if (progressBarCacheNew == null) {
            progressBarCacheNew = controlCaching.getControlComponent();
        }
        if (progressBarCacheNew == null) {
            progressBarCacheNew = controlCaching.getProgressBarComponent();
        }
        if (progressBarCacheNew == null) {
            return;
        }
        if (progressBarCacheNew == this.progressBarCache) {
            return;
        }
        if (this.mediaPlayerCurrent != null && this.mediaPlayerCurrent.getState() >= 300) {
            return;
        }
        this.killCurrentView();
        this.progressBarCache = progressBarCacheNew;
        this.panelContent.add(this.progressBarCache, "Center");
        this.setCursor(this.cursorNormal);
    }

    protected void processFormatChange(FormatChangeEvent event) {
        this.killCurrentView();
        this.panelVideo = new VideoPanel(this.mediaPlayerCurrent);
        this.panelVideo.setZoom(1.0);
        this.panelVideo.addMenuZoomActionListener(this);
        this.panelContent.add((Component)this.panelVideo, "Center");
        this.compControl = this.mediaPlayerCurrent.getControlPanelComponent();
        if (this.compControl != null) {
            this.panelContent.add(this.compControl, "South");
        }
    }

    protected void processReplaceURL(ControllerEvent event) {
        this.killCurrentPlayer();
        try {
            Class<?> classReplaceURLEvent = Class.forName("com.ibm.media.ReplaceURLEvent");
            Class<?> classEvent = event.getClass();
            classReplaceURLEvent.isAssignableFrom(classEvent);
            Method methodGetUrl = classEvent.getMethod("getURL", null);
            URL url = (URL)methodGetUrl.invoke((Object)event, null);
            this.open(url.toString());
        }
        catch (Exception e2) {
        }
        catch (Error e3) {
            // empty catch block
        }
    }

    public void componentAdded(ContainerEvent event) {
        if (event.getChild() != this.areaImagePlaceholder && this.areaImagePlaceholder != null && this.areaImagePlaceholder.getParent() == this.panelContent) {
            this.panelContent.remove(this.areaImagePlaceholder);
        }
        this.pack();
    }

    public void componentRemoved(ContainerEvent event) {
        if (this.panelContent.getComponentCount() < 1 && event.getChild() != this.areaImagePlaceholder) {
            this.setPlaceholder();
        } else {
            this.pack();
        }
    }

    public void windowClosed(WindowEvent event) {
        this.killCurrentPlayer();
    }

    public void windowClosing(WindowEvent event) {
        this.setVisible(false);
    }
}

