/*
 * Decompiled with CFR 0.152.
 */
package jmapps.util;

import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;

public class StateHelper
implements ControllerListener {
    Player player = null;
    boolean configured = false;
    boolean realized = false;
    boolean prefetched = false;
    boolean eom = false;
    boolean failed = false;
    boolean closed = false;

    public StateHelper(Player p) {
        this.player = p;
        p.addControllerListener(this);
    }

    public boolean configure() {
        return this.configure(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean configure(int timeOutMillis) {
        long startTime = System.currentTimeMillis();
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            if (this.player instanceof Processor) {
                ((Processor)this.player).configure();
            } else {
                return false;
            }
            while (!this.configured && !this.failed) {
                try {
                    this.wait(timeOutMillis);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime <= (long)timeOutMillis) continue;
            }
        }
        return this.configured;
    }

    public boolean realize() {
        return this.realize(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean realize(int timeOutMillis) {
        long startTime = System.currentTimeMillis();
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.realize();
            while (!this.realized && !this.failed) {
                try {
                    this.wait(timeOutMillis);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime <= (long)timeOutMillis) continue;
            }
        }
        return this.realized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prefetch(int timeOutMillis) {
        long startTime = System.currentTimeMillis();
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.prefetch();
            while (!this.prefetched && !this.failed) {
                try {
                    this.wait(timeOutMillis);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime <= (long)timeOutMillis) continue;
            }
        }
        return this.prefetched && !this.failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playToEndOfMedia(int timeOutMillis) {
        long startTime = System.currentTimeMillis();
        this.eom = false;
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.start();
            while (!this.eom && !this.failed) {
                try {
                    this.wait(timeOutMillis);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime <= (long)timeOutMillis) continue;
            }
        }
        return this.eom && !this.failed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StateHelper stateHelper = this;
        synchronized (stateHelper) {
            this.player.close();
            while (!this.closed) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.player.removeControllerListener(this);
    }

    public synchronized void controllerUpdate(ControllerEvent ce) {
        if (ce instanceof RealizeCompleteEvent) {
            this.realized = true;
        } else if (ce instanceof ConfigureCompleteEvent) {
            this.configured = true;
        } else if (ce instanceof PrefetchCompleteEvent) {
            this.prefetched = true;
        } else if (ce instanceof EndOfMediaEvent) {
            this.eom = true;
        } else if (ce instanceof ControllerErrorEvent) {
            this.failed = true;
        } else if (ce instanceof ControllerClosedEvent) {
            this.closed = true;
        } else {
            return;
        }
        this.notifyAll();
    }
}

