/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;

final class EphemeralKeyManager {
    private static final int INDEX_RSA512 = 0;
    private static final int INDEX_RSA1024 = 1;
    private final EphemeralKeyPair[] keys = new EphemeralKeyPair[]{new EphemeralKeyPair(null), new EphemeralKeyPair(null)};

    EphemeralKeyManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyPair getRSAKeyPair(boolean bl, SecureRandom secureRandom) {
        KeyPair keyPair;
        EphemeralKeyPair ephemeralKeyPair;
        int n;
        int n2;
        if (!bl) {
            n2 = 1024;
            n = 0;
        } else {
            n2 = 512;
            n = 1;
        }
        EphemeralKeyPair ephemeralKeyPair2 = ephemeralKeyPair = this.keys[n];
        synchronized (ephemeralKeyPair2) {
            keyPair = ephemeralKeyPair.getKeyPair();
            if (keyPair == null) {
                try {
                    KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                    keyPairGenerator.initialize(n2, secureRandom);
                    ephemeralKeyPair = new EphemeralKeyPair(keyPairGenerator.genKeyPair());
                    keyPair = ephemeralKeyPair.getKeyPair();
                    this.keys[n] = ephemeralKeyPair;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return keyPair;
    }

    private static class EphemeralKeyPair {
        private static final int MAX_USE = 200;
        private static final long USE_INTERVAL = 3600000L;
        private KeyPair keyPair;
        private int uses;
        private long expirationTime;

        private EphemeralKeyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            this.expirationTime = System.currentTimeMillis() + 3600000L;
        }

        private boolean isValid() {
            return this.keyPair != null && this.uses < 200 && System.currentTimeMillis() < this.expirationTime;
        }

        private KeyPair getKeyPair() {
            if (!this.isValid()) {
                this.keyPair = null;
                return null;
            }
            ++this.uses;
            return this.keyPair;
        }
    }
}

