/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.si;

import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;

public class SingleInstanceManager {
    private static String _idString;
    private static int _currPort;

    public static boolean isServerRunning(String string) {
        File file = new File(SingleInstanceImpl.SI_FILEDIR);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(SingleInstanceImpl.getSingleInstanceFilePrefix(string))) continue;
                try {
                    _currPort = Integer.parseInt(stringArray[i].substring(stringArray[i].lastIndexOf(95) + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    Trace.ignoredException(numberFormatException);
                    return false;
                }
                Trace.println("server running at port: " + _currPort, TraceLevel.TEMP);
                _idString = string;
                return true;
            }
        }
        return false;
    }

    public static boolean connectToServer(String string) {
        Trace.println("connect to: " + _idString + " " + _currPort, TraceLevel.TEMP);
        try {
            Socket socket = new Socket("127.0.0.1", _currPort);
            PrintStream printStream = new PrintStream(socket.getOutputStream());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            printStream.println("javaws.singleinstance.init");
            printStream.println(string);
            printStream.println("EOF");
            printStream.flush();
            Trace.println("waiting for ack", TraceLevel.TEMP);
            int n = 5;
            for (int i = 0; i < n; ++i) {
                String string2 = bufferedReader.readLine();
                if (string2 == null || !string2.equals("javaws.singleinstance.ack")) continue;
                Trace.println("GOT ACK", TraceLevel.TEMP);
                socket.close();
                return true;
            }
            socket.close();
        }
        catch (ConnectException connectException) {
            Trace.println("no server is running - continue launch!", TraceLevel.TEMP);
            return false;
        }
        catch (SocketException socketException) {
            Trace.println("no server is running - continue launch!", TraceLevel.TEMP);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

