/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunMidiFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

public class StandardMidiFileReader
extends SunMidiFileReader {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private InputStream stream;
    private DataInputStream dis;
    private Sequence sequence;
    private short type;
    private short tracks;
    private long tick;
    private int status;
    private int bytesRemaining = 0;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    private static final int bisBufferSize = 1024;
    public static final int[] types;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        types = nArray;
    }

    private Sequence constructSequence() throws IOException, InvalidMidiDataException {
        int resolution;
        float divisionType;
        String MThdString = new String("MThd");
        PushbackInputStream pis = new PushbackInputStream(this.stream);
        this.dis = new DataInputStream(pis);
        String chunkString = this.getChunkName();
        if (!chunkString.equals(MThdString)) {
            throw new InvalidMidiDataException("Invalid chunk name: " + chunkString + ": not a MIDI file");
        }
        this.bytesRemaining = this.dis.readInt();
        this.type = this.dis.readShort();
        this.bytesRemaining -= 2;
        if (this.type != 0 && this.type != 1) {
            throw new InvalidMidiDataException("Invalid or unsupported file type: " + this.type);
        }
        this.tracks = this.dis.readShort();
        this.bytesRemaining -= 2;
        int timing = this.dis.readShort();
        this.bytesRemaining -= 2;
        if (timing > 0) {
            divisionType = 0.0f;
            resolution = timing;
        } else {
            int frameCode = -1 * timing >> 8;
            switch (frameCode) {
                case 24: {
                    divisionType = 24.0f;
                    break;
                }
                case 25: {
                    divisionType = 25.0f;
                    break;
                }
                case 29: {
                    divisionType = 29.97f;
                    break;
                }
                case 30: {
                    divisionType = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Unknown frame code: " + frameCode);
                }
            }
            resolution = timing & 0xFF;
        }
        this.dis.skip(this.bytesRemaining);
        Sequence sequence = new Sequence(divisionType, resolution);
        return sequence;
    }

    private void findTrack() throws IOException, InvalidMidiDataException {
        String chunkString;
        String MTrkString = new String("MTrk");
        do {
            if ((chunkString = this.getChunkName()).equals(MTrkString)) continue;
            this.bytesRemaining = this.dis.readInt();
            this.dis.skip(this.bytesRemaining);
        } while (!chunkString.equals(MTrkString));
    }

    private String getChunkName() throws IOException {
        byte[] chunkBytes = new byte[4];
        this.dis.read(chunkBytes);
        return new String(chunkBytes);
    }

    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        MidiFileFormat fileFormat = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis, 1024);
        fileFormat = this.getMidiFileFormat(bis);
        bis.close();
        return fileFormat;
    }

    public MidiFileFormat getMidiFileFormat(InputStream stream) throws InvalidMidiDataException, IOException {
        int resolution;
        float divisionType;
        int maxReadLength = 16;
        int duration = -1;
        MidiFileFormat format = null;
        DataInputStream dis = new DataInputStream(stream);
        dis.mark(maxReadLength);
        int magic = dis.readInt();
        if (magic != 1297377380) {
            dis.reset();
            throw new InvalidMidiDataException("not a valid MIDI file");
        }
        int length = dis.readInt();
        length += 8;
        short filetype = dis.readShort();
        short numtracks = dis.readShort();
        int timing = dis.readShort();
        short type = filetype;
        if (timing > 0) {
            divisionType = 0.0f;
            resolution = timing;
        } else {
            int frameCode = -1 * timing >> 8;
            switch (frameCode) {
                case 24: {
                    divisionType = 24.0f;
                    break;
                }
                case 25: {
                    divisionType = 25.0f;
                    break;
                }
                case 29: {
                    divisionType = 29.97f;
                    break;
                }
                case 30: {
                    divisionType = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Unknown frame code: " + frameCode);
                }
            }
            resolution = timing & 0xFF;
        }
        dis.reset();
        length = -1;
        format = new MidiFileFormat(type, divisionType, resolution, length, duration);
        return format;
    }

    public MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        MidiFileFormat fileFormat = null;
        urlStream = url.openStream();
        bis = new BufferedInputStream(urlStream, 1024);
        fileFormat = this.getMidiFileFormat(bis);
        bis.close();
        return fileFormat;
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        fis = new FileInputStream(file);
        bis = new BufferedInputStream(fis, 1024);
        return this.getSequence(bis);
    }

    public Sequence getSequence(InputStream stream) throws InvalidMidiDataException, IOException {
        MidiFileFormat format = this.getMidiFileFormat(stream);
        this.stream = stream;
        this.sequence = this.constructSequence();
        int i = 0;
        while (i < this.tracks) {
            this.findTrack();
            this.readTrack();
            ++i;
        }
        return this.sequence;
    }

    public Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        InputStream urlStream = null;
        BufferedInputStream bis = null;
        urlStream = url.openStream();
        bis = new BufferedInputStream(urlStream, 1024);
        return this.getSequence(bis);
    }

    private int getType(int byteValue) throws InvalidMidiDataException {
        if ((byteValue & 0xF0) == 240) {
            switch (byteValue) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            throw new InvalidMidiDataException("Invalid status byte: " + byteValue);
        }
        switch (byteValue & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        throw new InvalidMidiDataException("Invalid status byte: " + byteValue);
    }

    private MidiEvent readEvent() throws IOException, InvalidMidiDataException {
        int data1 = -1;
        int data2 = 0;
        this.tick += (long)this.readVarInt();
        int byteValue = this.dis.readUnsignedByte();
        --this.bytesRemaining;
        if (byteValue >= 128) {
            this.status = byteValue;
        } else {
            data1 = byteValue;
        }
        int type = this.getType(this.status);
        switch (type) {
            case 1: {
                if (data1 == -1) {
                    data1 = this.dis.readUnsignedByte();
                    --this.bytesRemaining;
                }
                ShortMessage oneByteMessage = new ShortMessage();
                oneByteMessage.setMessage(this.status, data1, data2);
                MidiEvent event = new MidiEvent(oneByteMessage, this.tick);
                return event;
            }
            case 2: {
                if (data1 == -1) {
                    data1 = this.dis.readUnsignedByte();
                    --this.bytesRemaining;
                }
                data2 = this.dis.readUnsignedByte();
                --this.bytesRemaining;
                ShortMessage typeByteMessage = new ShortMessage();
                typeByteMessage.setMessage(this.status, data1, data2);
                MidiEvent event = new MidiEvent(typeByteMessage, this.tick);
                return event;
            }
            case 3: {
                int sysexLength = this.readVarInt();
                byte[] sysexData = new byte[sysexLength];
                this.bytesRemaining -= this.dis.read(sysexData);
                SysexMessage sysexMessage = new SysexMessage();
                sysexMessage.setMessage(this.status, sysexData, sysexLength);
                MidiEvent event = new MidiEvent(sysexMessage, this.tick);
                return event;
            }
            case 4: {
                int metaType = this.dis.readUnsignedByte();
                --this.bytesRemaining;
                int metaLength = this.readVarInt();
                byte[] metaData = new byte[metaLength];
                this.bytesRemaining -= this.dis.read(metaData);
                MetaMessage metaMessage = new MetaMessage();
                metaMessage.setMessage(metaType, metaData, metaLength);
                MidiEvent event = new MidiEvent(metaMessage, this.tick);
                return event;
            }
        }
        throw new InvalidMidiDataException("Internal parser error");
    }

    private Track readTrack() throws IOException, InvalidMidiDataException {
        this.tick = 0L;
        this.status = 0;
        Track track = this.sequence.createTrack();
        this.bytesRemaining = this.dis.readInt();
        while (this.bytesRemaining > 0) {
            track.add(this.readEvent());
        }
        return track;
    }

    private int readVarInt() throws IOException, InvalidMidiDataException {
        int value = 0;
        int currentByte = 0;
        int MAX_LENGTH = 6;
        int i = 0;
        while (i < MAX_LENGTH) {
            currentByte = this.dis.readUnsignedByte();
            --this.bytesRemaining;
            value = (value << 7) + (currentByte & 0x7F);
            if ((currentByte & 0x80) == 0) break;
            ++i;
        }
        if ((currentByte & 0x80) != 0) {
            throw new InvalidMidiDataException("Unterminated variable-length integer");
        }
        return value;
    }
}

